<?php $__env->startSection('content'); ?>
    <!-- APP MAIN ==========-->
    <main id="app-main" class="app-main">
        <div class="wrap">
            <section class="app-content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget p-lg">
                            <h4 class="m-b-lg">Detalles Clientes y Ventas</h4>
                            <table class="table client-table">
                                <thead class="visible-lg">
                                <tr>
                                    <th>Nombre</th>
                                    <th>Apellidos</th>
                                    <th>Barrio</th>
                                    <th>Total</th>
                                    <th>Pagados</th>
                                    <th>Vigentes</th>
                                    <th>Monto Prestado</th>
                                    <th>Monto Restante</th>
                                    <th>Tipo</th>
                                    <th>Accion</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><span class="value"><?php echo e($client->name); ?></span></td>
                                        <td><span class="value"><?php echo e($client->last_name); ?></span></td>
                                        <td><span class="value"><?php echo e($client->province); ?></span></td>
                                        <td><span class="value"><?php echo e($client->credit_count); ?></span></td>
                                        <td><span class="value"><?php echo e($client->closed); ?></span></td>
                                        <td><span class="value"><?php echo e($client->inprogress); ?></span></td>
                                        <td><span class="value"><?php echo e(isset($client->amount_net) ? $client->amount_net->amount_neto +$client->gap_credit : 0); ?></span></td>
                                        <td><span class="value"><?php echo e($client->summary_net + $client->gap_credit); ?></span></td>
                                        <td>
                                            <?php if($client->status=='good'): ?>
                                                <span class="badge-info badge">BUENO</span>
                                            <?php elseif($client->status=='bad'): ?>
                                                <span class="badge-danger badge">MALO</span>
                                            <?php endif; ?>

                                        </td>
                                        <td>
                                            <a href="<?php echo e(url('client/create')); ?>?id=<?php echo e($client->id); ?>" class="btn btn-success btn-xs">Venta</a>
                                            <a href="<?php echo e(url('client')); ?>/<?php echo e($client->id); ?>" class="btn btn-info btn-xs">Datos</a>
                                            <?php if(isset($client->lat) && isset($client->lng)): ?>
                                                <a href="http://www.google.com/maps/place/<?php echo e($client->lat); ?>,<?php echo e($client->lng); ?>" target="_blank" class="btn btn-info btn-xs">Ver Mapa</a>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody></table>
                        </div><!-- .widget -->
                    </div>
                </div><!-- .row -->
            </section>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/naciszrf/public_html/prestamos/resources/views/client/index.blade.php ENDPATH**/ ?>